const EMPTY_STATE = {
    error: null,
    device: null,
    state: "searching",
    version: "0.0.1",
    flashState: 0,
    flashMessage: ""
};

const app = new Vue({
    el: "#app",
    data() {
        return { ...EMPTY_STATE };
    },
    mounted() {
        this.$el.classList.remove("d-none");
        $event("device:found", (_, device) => {
            if (this.state == "searching") {
                this.state = "device";
                this.device = device;
            }
        });

        $event("flash:state", (_, state) => {
            this.flashState = state.progress * 100 + "%";
            this.flashMessage = state.message;
        });
    },
    methods: {
        async flash() {
            try {
                this.state = "flashing";
                await $api("device/flash", this.device);
                this.state = "flashed";
            } catch (e) {
                this.state = "error";
                this.error = e;
            }
        },
        reset() {
            Object.assign(this, EMPTY_STATE);
        }
    }
});
